package com.example.sefinsa_app.ui.folios;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.text.Editable;
import android.text.TextWatcher;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;

import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.ClienteController;
import com.example.sefinsa_app.controllers.ColocadoraController;
import com.example.sefinsa_app.controllers.FolioController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.Aval;
import com.example.sefinsa_app.models.Colocadora;
import com.example.sefinsa_app.models.Folio;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.ui.clientes.crear.ClientesCrearViewModel;
import com.example.sefinsa_app.ui.folios.ver.FolioAdapter;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.NetworkChange;
import com.example.sefinsa_app.utilities.VolleyS;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.textfield.TextInputLayout;
import com.google.gson.Gson;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class Folios extends Fragment {
    private static final String ARG_PARAM1 = "param1"; private static final String ARG_PARAM2 = "param2"; private static final Logger log = LoggerFactory.getLogger(Folios.class); private String mParam1; private String mParam2; public static Folios newInstance(String param1, String param2) { Folios fragment = new Folios(); Bundle args = new Bundle(); args.putString(ARG_PARAM1, param1); args.putString(ARG_PARAM2, param2); fragment.setArguments(args); return fragment; } public Folios() { }

    @Override
    public void onCreate(Bundle savedInstanceState) { super.onCreate(savedInstanceState); if (getArguments() != null) { mParam1 = getArguments().getString(ARG_PARAM1); mParam2 = getArguments().getString(ARG_PARAM2); } }

    FloatingActionButton btnAgregar;
    ArrayList<Folio> folios;

    TextInputLayout tlNombreFolio;
    AutoCompleteTextView acRuta;
    AutoCompleteTextView acPoblacion;

    public void filtrar() {
        FolioController fc = new FolioController(getActivity());
        if (fecha != null) {
            if (!Objects.equals(ruta_id, "") && !Objects.equals(poblacion_id, "")) {
                setUpRecyclerN(fc.getFolioRutaPoblacionFecha(ruta_id, poblacion_id, fecha));
            } else if (!Objects.equals(ruta_id, "") && Objects.equals(poblacion_id, "")) {
                setUpRecyclerN(fc.getFolioRutaFecha(ruta_id, fecha));
            } else if (Objects.equals(ruta_id, "") && !Objects.equals(poblacion_id, "")) {
                setUpRecyclerN(fc.getFolioPoblacionFecha(poblacion_id, fecha));
            } else if (!Objects.equals(cliente_id, "")) {
                setUpRecyclerN(fc.getFolioClienteFecha(cliente_id, fecha));
            } else {
                setUpRecyclerN(fc.getFolioFechaRutaId(fecha, iRutas));
            }
        } else {
            if (!Objects.equals(ruta_id, "") && !Objects.equals(poblacion_id, "")) {
                setUpRecyclerN(fc.getFolioRutaPoblacion(ruta_id, poblacion_id));
            } else if (!Objects.equals(ruta_id, "") && Objects.equals(poblacion_id, "")) {
                setUpRecyclerN(fc.getFolioRuta(ruta_id));
            } else if (Objects.equals(ruta_id, "") && !Objects.equals(poblacion_id, "")) {
                setUpRecyclerN(fc.getFolioPoblacion(poblacion_id));
            } else if (!Objects.equals(cliente_id, "")) {
                setUpRecyclerN(fc.getFolioCliente(cliente_id));
            } else {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    LocalDate today = LocalDate.now();

                    String[] pFecha = String.valueOf(today).split("-");
                    tlFecha.getEditText().setText(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]);
                    fecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
                }
                setUpRecyclerN(fc.getFolioFechaRutaId(fecha, iRutas));
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();

        cliente_id = "";
        ruta_id = "";
        poblacion_id = "";
        fecha = null;
        tlNombreFolio.getEditText().setText("");
        acRuta.setText("");
        acPoblacion.setText("");
        tlFecha.getEditText().setText("");

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            LocalDate today = LocalDate.now();

            String[] pFecha = String.valueOf(today).split("-");
            tlFecha.getEditText().setText(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]);
            fecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
        }
        filtrar();
    }

    public void syncServerDB() {
        FolioController fc = new FolioController(getContext());
        ArrayList<Folio> unsyncedFolios = new ArrayList<>();

        try {
            unsyncedFolios = fc.getUnsyncedFolios();
        } catch (Exception e) {
            fc.recreate();
            unsyncedFolios = fc.getUnsyncedFolios();
        }

        vs = VolleyS.getInstance(getActivity());
        requestQueue = vs.getRequestQueue();

        if (!unsyncedFolios.isEmpty()) {
            for (Folio folio : unsyncedFolios) {
                fc.syncFolio(
                        String.valueOf(folio.getId()),
                        String.valueOf(folio.getFecha()),
                        String.valueOf(folio.getHora()),
                        String.valueOf(folio.getCliente_id()),
                        String.valueOf(folio.getRuta_id()),
                        String.valueOf(folio.getPoblacion_id()),
                        String.valueOf(folio.getMonto()),
                        String.valueOf(folio.getMonto_letra()),
                        String.valueOf(folio.getConcepto()),
                        String.valueOf(folio.getFirma_usuario()),
                        String.valueOf(folio.getFirma_cliente())
                );
                Log.d("sync", "onCreateView: sync");
            }
        }

        fc.getTotalFolios(new FolioController.FolioCountCallback() {
            @Override
            public void onSuccess(int total) {
                fc.getFolioDataAndSave(new FolioController.FolioDownloadCallback() {
                    @Override
                    public void onDownloadComplete() {
                        fc.getFoliosCanceladosServidor(new FolioController.FolioEliminarCallback() {
                            @Override
                            public void onSuccess() {
                                filtrar();
                                dialog.dismiss();
                            }

                            @Override
                            public void onError(String error) {
                                filtrar();
                                dialog.dismiss();
                            }

                            @Override
                            public void onSucess() {
                                filtrar();
                                dialog.dismiss();
                            }
                        });
                    }
                });
            }

            @Override
            public void onError(String error) {
                Log.e("FoliosCount", "Error: " + error);
                fc.getFolioDataAndSave(new FolioController.FolioDownloadCallback() {
                    @Override
                    public void onDownloadComplete() {
                        fc.getFoliosCanceladosServidor(new FolioController.FolioEliminarCallback() {
                            @Override
                            public void onSuccess() {
                                filtrar();
                                dialog.dismiss();
                            }

                            @Override
                            public void onError(String error) {
                                filtrar();
                                dialog.dismiss();
                            }

                            @Override
                            public void onSucess() {
                                filtrar();
                                dialog.dismiss();
                            }
                        });
                    }
                });
            }
        });
    }

    ProgressDialog dialog;
    String empleado_id;

    public void prepararFolios() {
        AlertDialog.Builder builder = new AlertDialog.Builder(getContext());
        LayoutInflater inflater = getLayoutInflater();
        View dialogLayout = inflater.inflate(R.layout.preraparfolio, null);
        builder.setView(dialogLayout);

        final TextInputLayout tlCantidad = dialogLayout.findViewById(R.id.tlCantidad);

        builder.setTitle("Preparar folios")
                .setPositiveButton("Crear", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int id) {
                        FolioController fc = new FolioController(getContext());
                        fc.prepararFolios(empleado_id, tlCantidad.getEditText().getText().toString());
                        dialog.dismiss();
                    }
                })
                .setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        dialog.dismiss();
                    }
                });

        AlertDialog dialog = builder.create();
        dialog.show();
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                dialog.show();
                syncServerDB();
                acRuta.setText("");
                acPoblacion.setText("");
                ruta_id = "";
                poblacion_id = "";
                tlNombreFolio.getEditText().setText("");
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    public void compartirPagoReporteFolio(Folio folio) throws ParseException {
        try {
            String text = "----------------------------------------------------\n";
            text += "PRESTAMO GRUSEF S.A. de C.V.\n";
            text += "Folio: " + folio.getId() + "\n";
            text += "Fecha: " + folio.getFecha() + "\n";

            RutaController rc = new RutaController(getContext());
            String ruta =  rc.getNombreRuta(folio.getRuta_id());
            text += "Ruta: " + ruta + "\n";

            PoblacionController pc = new PoblacionController(getContext());
            String poblacion = pc.getNombrePoblacion(folio.getPoblacion_id());
            text += "Población: " + poblacion + "\n";

            ClienteController cc = new ClienteController(getContext());
            String cliente = folio.getCliente_id();
            text += "Recibí de:\n" + cliente  + "\n";

            text += "Cantidad: $" + folio.getMonto() + "\n";
            text += saltoLinea(folio.getMonto_letra());
            text += "\nConcepto: \n";
            text += saltoLinea(folio.getConcepto());

            File pdfFile = generarPDF(text, folio.getFirma_cliente(), folio.getFirma_usuario());

            compartirPDF(pdfFile);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    public static String saltoLinea(String texto) {
        String[] palabras = texto.split(" ");
        StringBuilder contenido = new StringBuilder();
        Integer cont = 0;

        for (String palabra : palabras) {
            if (cont + palabra.length() < 28) {
                contenido.append(palabra).append(" ");
                cont += palabra.length() + 1;
            } else {
                contenido.append("\n").append(palabra).append(" ");
                cont = palabra.length() + 1;
            }
        }
        return contenido.toString();
    }

    private void compartirPDF(File pdfFile) {
        try {
            Intent intent = new Intent(Intent.ACTION_SEND);
            intent.setType("application/pdf");
            Uri pdfUri = FileProvider.getUriForFile(getContext(), getContext().getApplicationContext().getPackageName() + ".provider", pdfFile);
            intent.putExtra(Intent.EXTRA_STREAM, pdfUri);
            startActivity(Intent.createChooser(intent, "Compartir mediante"));
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    private File generarPDF(String content, String fc, String fu) throws IOException {
        // Crear un nuevo documento PDF
        File pdfFile = new File(getContext().getCacheDir(), "Folio.pdf");
        PdfWriter writer = new PdfWriter(pdfFile);
        PdfDocument pdf = new PdfDocument(writer);
        Document document = new Document(pdf);

        // Obtener la imagen desde los recursos y agregarla al PDF
        Drawable drawable = getResources().getDrawable(R.drawable.sefinsa_ticket);
        BitmapDrawable bitmapDrawable = (BitmapDrawable) drawable;
        Bitmap bitmap = bitmapDrawable.getBitmap();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, stream);
        ImageData imageData = ImageDataFactory.create(stream.toByteArray());
        Image image = new Image(imageData);
        document.add(image);

        Paragraph p = new Paragraph(content);
        p.setFontSize(6);
        document.add(p);

        Paragraph p2 = new Paragraph("Firma del administrador: \n");
        p2.setFontSize(8);
        document.add(p2);

        byte[] decodedBytes2 = Base64.decode(fu, Base64.DEFAULT);
        bitmap = BitmapFactory.decodeByteArray(decodedBytes2, 0, decodedBytes2.length);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos2);
        ImageData imageData3 = ImageDataFactory.create(baos2.toByteArray());
        Image image3 = new Image(imageData3);
        image3.scaleToFit(100, 100);
        document.add(image3);

        Paragraph p3 = new Paragraph("Firma del colocador(a): \n");
        p3.setFontSize(8);
        document.add(p3);

        byte[] decodedBytes = Base64.decode(fc, Base64.DEFAULT);
        bitmap = BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos1);
        ImageData imageData2 = ImageDataFactory.create(baos1.toByteArray());
        Image image2 = new Image(imageData2);
        image2.scaleToFit(100, 100);
        document.add(image2);

        // Cerrar el documento
        document.close();

        return pdfFile;
    }

    @SuppressLint("MissingInflatedId")
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_folios, container, false);

        SharedPreferences sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        empleado_id = sesion.getString("id", null);
        Log.d("empleadoID", "onCreateView: " + empleado_id);

        dialog = new ProgressDialog(getActivity(), R.style.AppMaterialAlertDialogStyle);
        dialog.setMessage("Cargando datos, por favor espere...");
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();

        tlFecha = view.findViewById(R.id.tlFecha);

        FolioController fc = new FolioController(getContext());

        btnAgregar = view.findViewById(R.id.btnAbrirAgregarFolio);
        rv = view.findViewById(R.id.rvFolios);

        btnAgregar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                FolioController fc = new FolioController(getContext());

                if (fc.getUsuarioFolios(empleado_id).isEmpty()) {
                    if (NetworkChange.isConnectedToInternet(getContext())) {
                        prepararFolios();
                    } else {
                        AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                        builder.setTitle("No hay conexión a internet")
                                .setMessage("No se pueden preparar folios")
                                .setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                                    public void onClick(DialogInterface dialog, int id) {
                                        dialog.dismiss();
                                    }
                                });

                        AlertDialog dialog = builder.create();
                        dialog.show();
                    }
                } else {
                    Navigation.findNavController(requireActivity(), R.id.nav_host_fragment_content_dashboard).navigate(R.id.nav_crear_folio);
                }
            }

            private Object getSystemService(String connectivityService) { return null; }
        });

        tlNombreFolio = view.findViewById(R.id.tlNombreFolio);
        acRuta = view.findViewById(R.id.acRuta);
        acPoblacion = view.findViewById(R.id.acPoblacion);

        tlNombreFolio.getEditText().addTextChangedListener(new TextWatcher() {
            @Override public void beforeTextChanged(CharSequence s, int start, int count, int after) { }
            @Override public void onTextChanged(CharSequence s, int start, int before, int count) { }

            @Override
            public void afterTextChanged(Editable s) {
                String input = s.toString();
                FolioController fc = new FolioController(getContext());

                acRuta.setText("");
                acPoblacion.setText("");
                poblacion_id = "";
                ruta_id = "";

                if (input.matches("\\d+")) {
                    setUpRecyclerN(fc.getLikeFolios(String.valueOf(s), iRutas));
                } else if (input.isEmpty()) {
                    cliente_id = "";
                    filtrar();
                } else {
                    acPoblacion.setText("");
                    acRuta.setText("");
                    poblacion_id = "";
                    ruta_id = "";
                    setUpRecyclerN(fc.getLikeNombre(String.valueOf(s), fecha, iRutas));
                }

            }
        });

        acRuta.addTextChangedListener(new TextWatcher() {
            @Override public void beforeTextChanged(CharSequence s, int start, int count, int after) { }
            @Override public void onTextChanged(CharSequence s, int start, int before, int count) { }

            @Override
            public void afterTextChanged(Editable s) {
                String input = s.toString();

                if (input.isEmpty()) {
                    ruta_id = "";
                    poblacion_id = "";

                    filtrar();
                }
            }
        });

        acPoblacion.addTextChangedListener(new TextWatcher() {
            @Override public void beforeTextChanged(CharSequence s, int start, int count, int after) { }
            @Override public void onTextChanged(CharSequence s, int start, int before, int count) {}

            @Override
            public void afterTextChanged(Editable s) {
                String input = s.toString();

                Log.d("weqweqw", "afterTextChanged: " + s);

                if (input.isEmpty()) {
                    if (!Objects.equals(poblacion_id, "")) {
                        filtrar();
                    }
                    poblacion_id = "";
                } else {
                    filtrar();
                }
            }
        });
        folios = fc.index();

        setHasOptionsMenu(true);

        return view;
    }

    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) { super.onCreateOptionsMenu(menu, inflater); }

    private RecyclerView rv;

    public void setUpRecyclerN (ArrayList<Folio> folios) {
        FolioAdapter adapter = new FolioAdapter(folios, getContext(), getActivity(), this);
        RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(getContext());
        rv.setLayoutManager(layoutManager);
        rv.setItemAnimator(new DefaultItemAnimator());
        rv.setAdapter(adapter);
    }

    private ClientesCrearViewModel mViewModel;

    private TextInputLayout tlNombreCliente;

    private AutoCompleteTextView rutasAutoCompleteTextView;
    private AutoCompleteTextView poblacionesAutoCompleteTextView;
    private AutoCompleteTextView colocadorasAutoCompleteTextView;
    private AutoCompleteTextView clientesAutoCompleteTextView;

    private VolleyS vs;
    private RequestQueue requestQueue;

    private ArrayList<Ruta> rutas;
    private ArrayList<String> iRutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;

    private ArrayList<Colocadora> colocadoras;
    private ArrayAdapter<Colocadora> colocadorasAdapter;

    private String ruta_id = "";
    private String poblacion_id = "";
    private String cliente_id = "";

    private ClienteController clienteController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private ColocadoraController colocadoraController;
    private String selectedAval = "";
    private HashMap<String, String> avalMap;

    FusedLocationProviderClient client;

    TextInputLayout tlFecha;
    TextInputLayout tlHora;

    private String fecha = null;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        client = LocationServices.getFusedLocationProviderClient(getActivity());

        initElements(view);

        rutas = new ArrayList<Ruta>();
        poblaciones = new ArrayList<Poblacion>();
        colocadoras = new ArrayList<Colocadora>();

        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        getRutas();

        rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = rutasAdapter.getItem(i);
                ruta_id = ruta.getId();
                filtrar();

                if (poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    poblacionesAutoCompleteTextView.setText("");
                }

                List<Poblacion> poblacionesFiltro = poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());

                poblacionesAdapter = new ArrayAdapter<Poblacion>(requireActivity(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);
                poblacionesAutoCompleteTextView.setThreshold(1);
                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

            }
        });

        rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) { }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) { }

            @Override
            public void afterTextChanged(Editable s) {
                if (s.length() == 0) {
                    ruta_id = "";
                    poblacionesAutoCompleteTextView.setText("");
                    poblacion_id = "";
                    filtrar();
                } else {
                    String[] rutaArr = s.toString().split(" ");
                    if (rutaArr.length > 1) {
                        if (iRutas.contains(rutaArr[1])) {
                            FolioController fc = new FolioController(getContext());
                            String rutaId = fc.verificarRuta(s.toString());
                            if (!Objects.equals(rutaId, "") || rutaId != null) {
                                ruta_id = rutaId;

                                List<Poblacion> poblacionesFiltro = null;
                                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
                                    poblacionesFiltro = poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());
                                }

                                poblacionesAutoCompleteTextView.setText("");
                                poblacionesAdapter = new ArrayAdapter<Poblacion>(requireActivity(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);
                                poblacionesAutoCompleteTextView.setThreshold(1);
                                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

                                filtrar();
                            }
                        }
                    }
                }
            }
        });

        if (poblaciones.size() == 0) {
            getPoblaciones(ruta_id);
        }

        poblacionesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Poblacion poblacion = poblacionesAdapter.getItem(i);
                poblacion_id = poblacion.getId();
                filtrar();
            }
        });

        poblacionesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) { }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) { }

            @Override
            public void afterTextChanged(Editable s) {
                if (s.length() == 0) {
                    poblacion_id = "";
                    filtrar();
                } else {
                    FolioController fc = new FolioController(getContext());
                    String poblacionId = fc.verificarPoblacion(s.toString());
                    if (!Objects.equals(poblacionId, "") || poblacionId != null) {
                        poblacion_id = poblacionId;
                        filtrar();
                    }
                }
            }
        });

        rutasAutoCompleteTextView.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View view, boolean hasFocus) {
                if (!hasFocus && rutasAutoCompleteTextView.getText().toString().isEmpty()) {
                    poblacionesAdapter = null;
                    poblacionesAdapter = new ArrayAdapter<Poblacion>(requireActivity(), android.R.layout.simple_dropdown_item_1line, poblaciones);
                    poblacionesAutoCompleteTextView.setThreshold(1);
                    poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);
                }
            }
        });

        configurarAutoCompleteTextView();
        SQLiteDatabase db = new DatabaseHelper(requireContext()).getReadableDatabase();

        llenarAutoComplete(db);
    }

    private void initElements(View view) {

        CurrentFragment.fragment = "ClientesCrearFragment";

        tlFecha = view.findViewById(R.id.tlFecha);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            LocalDate today = LocalDate.now();

            String[] pFecha = String.valueOf(today).split("-");
            tlFecha.getEditText().setText(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]);
        }

        tlHora = view.findViewById(R.id.tlHora);

        rutasAutoCompleteTextView = view.findViewById(R.id.acRuta);
        poblacionesAutoCompleteTextView = view.findViewById(R.id.acPoblacion);
        colocadorasAutoCompleteTextView = view.findViewById(R.id.acColocadora);
        tlNombreCliente = view.findViewById(R.id.tlNombreCliente);
        clientesAutoCompleteTextView = view.findViewById(R.id.acCrearNombreCliente);

        rutaController = new RutaController(getActivity());
        poblacionController = new PoblacionController(getActivity());
        colocadoraController = new ColocadoraController(getActivity());
        clienteController = new ClienteController(getActivity());

        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

        scheduler.schedule(new Runnable() {
            @Override
            public void run() {
                dialog.dismiss();
            }
        }, 25, TimeUnit.SECONDS);

        syncServerDB();

        tlFecha.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                FolioController fc = new FolioController(getContext());
                LocalDate today = null;
                String date = null;
                acRuta.setText("");
                acPoblacion.setText("");
                ruta_id = "";
                poblacion_id = "";
                tlNombreFolio.getEditText().setText("");

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    today = LocalDate.now();
                    String[] pFecha = String.valueOf(today).split("-");
                    date = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
                }
                if (!Objects.equals(fecha, date)) {
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                        tlFecha.getEditText().setText(date);
                        fecha = date;
                        filtrar();
                    }
                } else {
                    MaterialDatePicker.Builder<Long> materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                    materialDateBuilder.setTitleText("Fecha");

                    CalendarConstraints.Builder constraintsBuilder = new CalendarConstraints.Builder();
                    constraintsBuilder.setEnd(MaterialDatePicker.todayInUtcMilliseconds());

                    materialDateBuilder.setCalendarConstraints(constraintsBuilder.build());

                    MaterialDatePicker<Long> materialDatePicker = materialDateBuilder.build();
                    materialDatePicker.show(getChildFragmentManager(), "MATERIAL_DATE_PICKER");

                    materialDatePicker.addOnPositiveButtonClickListener(
                            new MaterialPickerOnPositiveButtonClickListener<Long>() {
                                @SuppressLint("SetTextI18n")
                                @Override
                                public void onPositiveButtonClick(Long selection) {
                                    TimeZone timeZoneUTC = TimeZone.getDefault();
                                    int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                                    SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                                    Date date = new Date(selection + offsetFromUTC);

                                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                                        LocalDate today = LocalDate.now();
                                        Instant instant = date.toInstant();
                                        ZoneId zoneId = ZoneId.systemDefault();
                                        LocalDate selectedDate = instant.atZone(zoneId).toLocalDate();

                                        if (selectedDate.isAfter(today)) {
                                            AlertDialog.Builder builder = new AlertDialog.Builder(getActivity());
                                            builder.setTitle("Fecha invalida");
                                            builder.setMessage("La fecha ingresada no puede ser mayor a la de hoy.");

                                            builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                                                public void onClick(DialogInterface dialog, int id) {
                                                    dialog.dismiss();
                                                }
                                            });

                                            AlertDialog dialog = builder.create();
                                            dialog.show();
                                        }
                                        else {
                                            String f = simpleFormat.format(date);
                                            String[] pFecha = f.split("-");
                                            String mFecha = pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0];
                                            tlFecha.getEditText().setText(mFecha);

                                            fecha = mFecha;

                                            filtrar();
                                        }
                                    }
                                }
                            });
                }
            }
        });
    }

    private List<Aval> obtenerListaAvales() {
        List<Aval> listaAvales = new ArrayList<>();
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String sqlQuery = "SELECT * FROM clientes WHERE nombre_completo IS NOT NULL AND nombre_completo != '' ORDER BY nombre_completo ASC";
        Cursor cursor = db.rawQuery(sqlQuery, null);

        if (cursor != null && cursor.moveToFirst()) {
            do {
                Aval aval = new Aval(
                        cursor.getString(cursor.getColumnIndexOrThrow("id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                        cursor.getString(cursor.getColumnIndexOrThrow("direccion")),
                        cursor.getString(cursor.getColumnIndexOrThrow("telefono")),
                        cursor.getString(cursor.getColumnIndexOrThrow("garantias")),
                        cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias")),
                        cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("colocadora_id"))
                );
                listaAvales.add(aval);
            } while (cursor.moveToNext());

            cursor.close();
        }
        db.close();
        return listaAvales;
    }
    private void configurarAutoCompleteTextView() {
        new ObtenerAvalesTask().execute();
    }

    private class ObtenerAvalesTask extends AsyncTask<Void, Void, List<Aval>> {
        @Override
        protected List<Aval> doInBackground(Void... voids) {
            List<Aval> listaAvales = obtenerListaAvales();

            listaAvales.sort((aval1, aval2) -> {
                try {
                    int id1 = Integer.parseInt(aval1.getId() != null ? aval1.getId() : "0");
                    int id2 = Integer.parseInt(aval2.getId() != null ? aval2.getId() : "0");
                    return Integer.compare(id2, id1);
                } catch (NumberFormatException e) {
                    return 0;
                }
            });

            Set<String> nombresUnicos = new HashSet<>();
            List<String> nombresAvales = new ArrayList<>();
            for (Aval aval : listaAvales) {
                if (nombresUnicos.add(aval.getNombre_completo())) {
                    nombresAvales.add(aval.getNombre_completo());
                }
            }

            return listaAvales;
        }
    }

    public List<Map<String, String>> getClientesYDisponibles(SQLiteDatabase db) {
        List<Map<String, String>> clientes = new ArrayList<>();
        List<Map<String, String>> avales = new ArrayList<>();
        List<Map<String, String>> resultado = new ArrayList<>();

        String queryClientes = "SELECT id, nombre_completo, 'cliente' AS tipo " +
                "FROM clientes " +
                "WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorClientes = db.rawQuery(queryClientes, null);
        if (cursorClientes != null) {
            while (cursorClientes.moveToNext()) {
                Map<String, String> registro = new HashMap<>();
                registro.put("id", cursorClientes.getString(0));
                registro.put("nombre_completo", cursorClientes.getString(1).trim().toLowerCase()); // Normalizar nombre
                registro.put("tipo", cursorClientes.getString(2));
                clientes.add(registro);
            }
            cursorClientes.close();
        }

        String queryAvales = "SELECT id, nombre_completo, 'aval' AS tipo " +
                "FROM avales " +
                "WHERE nombre_completo IS NOT NULL AND TRIM(nombre_completo) != ''";
        Cursor cursorAvales = db.rawQuery(queryAvales, null);
        if (cursorAvales != null) {
            while (cursorAvales.moveToNext()) {
                Map<String, String> registro = new HashMap<>();
                registro.put("id", cursorAvales.getString(0));
                registro.put("nombre_completo", cursorAvales.getString(1).trim().toLowerCase()); // Normalizar nombre
                registro.put("tipo", cursorAvales.getString(2));
                avales.add(registro);
            }
            cursorAvales.close();
        }

        Set<String> nombresUnicos = new HashSet<>();

        Set<String> nombresAvales = new HashSet<>();
        for (Map<String, String> aval : avales) {
            nombresAvales.add(aval.get("nombre_completo"));
        }

        for (Map<String, String> cliente : clientes) {
            String nombreCliente = cliente.get("nombre_completo");
            if (!nombresAvales.contains(nombreCliente) && !nombresUnicos.contains(nombreCliente)) {
                resultado.add(cliente);
                nombresUnicos.add(nombreCliente);
            }
        }

        for (Map<String, String> aval : avales) {
            String nombreAval = aval.get("nombre_completo");
            if (!nombresUnicos.contains(nombreAval)) {
                resultado.add(aval);
                nombresUnicos.add(nombreAval);
            }
        }

        return resultado;
    }

    @SuppressLint("StaticFieldLeak")
    private void llenarAutoComplete(SQLiteDatabase db) {
        new AsyncTask<Void, Void, List<Map<String, String>>>() {
            @Override
            protected List<Map<String, String>> doInBackground(Void... voids) {
                return getClientesYDisponibles(db);
            }

            @Override
            protected void onPostExecute(List<Map<String, String>> datos) {
                List<String> nombres = new ArrayList<>();
                Map<String, Map<String, String>> idMap = new HashMap<>();

                for (Map<String, String> registro : datos) {
                    String nombre = registro.get("nombre_completo");
                    if (nombre != null && !nombre.trim().isEmpty()) {
                        nombres.add(nombre);
                        idMap.put(nombre, registro);
                    }
                }
            }
        }.execute();
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mViewModel = new ViewModelProvider(this).get(ClientesCrearViewModel.class);
    }

    private SharedPreferences sesion;

    public void getRutas() {
        // Obtener el ruta_id de la sesión
        String rutaIdSesion = sesion.getString("rutas", "");
        Log.d("getRutas", "Ruta ID de la sesión: " + rutaIdSesion);

        // Descomponer los IDs de la sesión en una lista
        List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d("getRutas", "Ruta IDs de la sesión descompuestos: " + rutaIdsSesion);

        // Verificar si ya tenemos rutas guardadas localmente
        if (rutaController.obtener().size() == 0) {
            Log.d("getRutas", "No se encontraron rutas guardadas localmente. Solicitando desde el servidor.");

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");
            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            Log.d("getRutas", "Respuesta del servidor: " + response.toString());
                            try {
                                JSONArray data = response.getJSONArray("data");
                                Log.d("getRutas", "Cantidad de rutas recibidas: " + data.length());

                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);
                                    Log.d("getRutas", "Ruta JSON recibida: " + obj.toString());

                                    Gson gson = new Gson();
                                    Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                    // Filtrar rutas para que solo se incluyan aquellas con el ruta_id de la sesión
                                    if (rutaIdsSesion.contains(ruta.getId())) {
                                        rutas.add(ruta);
                                        rutaController.nueva(ruta);
                                        Log.d("getRutas", "Ruta añadida: " + ruta.toString());
                                    }
                                }

                                // Crear y configurar el adaptador solo con las rutas filtradas
                                rutasAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
                                rutasAutoCompleteTextView.setThreshold(1);
                                rutasAutoCompleteTextView.setAdapter(rutasAdapter);
                                Log.d("getRutas", "Adaptador configurado con " + rutas.size() + " rutas.");
                            } catch (JSONException e) {
                                e.printStackTrace();
                                Log.e("getRutas", "Error al procesar respuesta del servidor: " + e.getMessage());
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    Log.e("getRutas", "Error en la solicitud de rutas: " + error.getMessage());
                    ErrorChecker.checker(error, getActivity());
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    3,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
            Log.d("getRutas", "Solicitud enviada al servidor.");
        } else {
            // Recuperar las rutas de la base de datos local y filtrar por los IDs en la sesión
            Log.d("getRutas", "Recuperando rutas guardadas localmente.");
            List<Ruta> rutasGuardadas = rutaController.obtener();
            Log.d("getRutas", "Cantidad de rutas locales encontradas: " + rutasGuardadas.size());

            if (iRutas == null) { iRutas = new ArrayList<>(); }

            for (Ruta ruta : rutasGuardadas) {
                Log.d("getRutas", "Ruta local encontrada: " + ruta.toString());
                // Verificar si el ID de la ruta está en la lista de IDs de la sesión
                if (rutaIdsSesion.contains(ruta.getId())) {
                    rutas.add(ruta);
                    Log.d("getRutas", "Ruta añadida tras filtrar: " + ruta);
                }
            }

            // Crear y configurar el adaptador solo con las rutas filtradas
            rutasAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
            rutasAutoCompleteTextView.setThreshold(1);
            rutasAutoCompleteTextView.setAdapter(rutasAdapter);
            Log.d("getRutas", "Adaptador configurado con " + rutas.size() + " rutas locales.");
            Log.d("aweqw", "getRutas: " + rutas.toString());
            for (int i = 0; i < rutas.size(); i++) {
                String r = String.valueOf(rutas.get(i));
                String[] ar = r.split(" ");
                String c = ar[1];
                Log.d("qweqweqw", "getRutas: " + c);
                iRutas.add(c);
            }
            Log.d("irutas", "getRutas: " + iRutas);
        }
        filtrar();
    }

    private void getPoblaciones(String ruta_id) {
        if (poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                    poblaciones.add(poblacion);
                                    poblacionController.nueva(poblacion);

                                }

                                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
                                poblacionesAutoCompleteTextView.setThreshold(1);
                                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);
                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {

            poblaciones = poblacionController.obtener();

            poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
            poblacionesAutoCompleteTextView.setThreshold(1);
            poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

        }
    }
}